#include <Ultrasonic_Sensor.h>  //βιβλιοθήκη για τον αισθητήρα υπερήχων

const int trigPin = 3;          // Δήλωση 1ης θύρας αισθητήρα υπερήχων
const int echoPin = 4;          // Δήλωση 2ης θύρας αισθητήρα υπερήχων

float t;                        //Χρόνος σε s που απαιτείται για τη μετάδοση του υπέρηχου από τον αισθητήρα έως το εμπόδιο
float u = 346.9;                // Ταχύτητα ήχου u=331.3+0.6*T; (ταχύτητα σε συνάρτηση με τη θερμοκρασία T σε κελσίου)
float x;                        //απόσταση εμποδίου

Ultrasonic_Sensor ultrasonic(trigPin, echoPin); // Εκκίνηση Αισθητήρα υπερήχων

void setup() 
{
  Serial.begin(9600); // Έναρξη Σειριακής με ταχύτητα 9600
  
}

void loop() 
{
  ultrasonic.sendTriggerPulse(); // Στέλνουμε παλμό υπέρηχου στο εμπόδιο
  
  long duration = ultrasonic.readEcho();    // Χρόνος σε μS από την αποστολή του υπέρηχου έως την επιστροφή του στον αισθητήρα
  t = 0.5 * (duration / 1000000.0);         // Χρόνος σε s για μετάδοση του υπέρηχου από τον αισθητήρα έως το εμπόδιο
  x = u * t;                                // Υπολογισμός απόστασης εμποδίου

  Serial.print("Απόσταση x = ");            // Εμφάνιση κειμένου στο Σειριακό Παράθυρο (Tools/Serial Monitor)
  Serial.print(x, 3);                       // Εμφάνιση τιμής της μεταβλητής x (απόσταση) στο Σειριακό Παράθυρο (Tools/Serial Monitor)
  Serial.println(" m");                     // Εμφάνιση κειμένου στο Σειριακό Παράθυρο

  delay(1000);                              //καθυστέρηση για να διαβάσουμε την τιμή
}
